/*
 * Decompiled with CFR 0.152.
 */
package adql.query;

import adql.query.ADQLObject;
import adql.query.ColumnReference;

public class ADQLOrder
extends ColumnReference {
    private boolean descSorting = false;

    public ADQLOrder(int n) throws ArrayIndexOutOfBoundsException {
        this(n, false);
    }

    public ADQLOrder(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        super(n);
        this.descSorting = bl;
    }

    public ADQLOrder(String string) throws NullPointerException {
        this(string, false);
    }

    public ADQLOrder(String string, boolean bl) throws NullPointerException {
        super(string);
        this.descSorting = bl;
    }

    public ADQLOrder(ADQLOrder aDQLOrder) {
        super(aDQLOrder);
        this.descSorting = aDQLOrder.descSorting;
    }

    public boolean isDescSorting() {
        return this.descSorting;
    }

    public void setOrder(int n, boolean bl) throws ArrayIndexOutOfBoundsException {
        if (n <= 0) {
            throw new ArrayIndexOutOfBoundsException("Impossible to make a reference to the " + n + "th column: a column index must be greater or equal 1 !");
        }
        this.setColumnIndex(n);
        this.descSorting = bl;
    }

    public void setOrder(String string, boolean bl) throws NullPointerException {
        if (string == null) {
            throw new NullPointerException("Impossible to make a reference: the given name is null or is an empty string !");
        }
        this.setColumnName(string);
        this.descSorting = bl;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLOrder(this);
    }

    @Override
    public String getName() {
        return super.getName() + (this.descSorting ? " DESC" : " ASC");
    }

    @Override
    public String toADQL() {
        return super.toADQL() + (this.descSorting ? " DESC" : " ASC");
    }
}

